const audio = new Audio();
let currentId = null;
async function playSongById(id,title,artist,cover){
  currentId = id;
  audio.src = `/backend/stream.php?id=${id}`;
  try{ await audio.play(); }catch(e){ console.log(e); }
  document.getElementById('playerTitle').innerText = title;
  document.getElementById('playerArtist').innerText = artist;
  document.getElementById('playerCover').src = cover || '/frontend/assets/covers/cover1.png';
  // notify play
  fetch('/backend/api/play.php', {method:'POST', body: new URLSearchParams({song_id:id})});
}
audio.addEventListener('timeupdate', ()=> {
  const pct = audio.duration ? (audio.currentTime / audio.duration) * 100 : 0;
  document.querySelector('.player .progress > i').style.width = pct + '%';
});
