<?php
require __DIR__ . '/common.php';
if(!is_admin()) { http_response_code(403); echo json_encode(['error'=>'forbidden']); exit; }

$allowedAudio = ['audio/mpeg','audio/mp3','audio/ogg','audio/wav'];
$allowedImages = ['image/jpeg','image/png','image/webp','image/svg+xml'];

$res = ['uploaded'=>[]];

$uploadsSongs = __DIR__ . '/../uploads/songs';
$uploadsCovers = __DIR__ . '/../uploads/covers';
if(!is_dir($uploadsSongs)) mkdir($uploadsSongs, 0755, true);
if(!is_dir($uploadsCovers)) mkdir($uploadsCovers, 0755, true);

if(!empty($_FILES['song'])) {
  $song = $_FILES['song'];
  if(in_array($song['type'], $allowedAudio)) {
    $fn = time() . '-' . preg_replace('/[^a-zA-Z0-9\._-]/','_', basename($song['name']));
    $dest = $uploadsSongs . '/' . $fn;
    move_uploaded_file($song['tmp_name'], $dest);
    $res['uploaded']['song'] = 'uploads/songs/' . $fn;
  } else $res['error_song'] = 'Invalid audio type';
}

if(!empty($_FILES['cover'])) {
  $cover = $_FILES['cover'];
  if(in_array($cover['type'], $allowedImages)) {
    $fn = time() . '-' . preg_replace('/[^a-zA-Z0-9\._-]/','_', basename($cover['name']));
    $dest = $uploadsCovers . '/' . $fn;
    move_uploaded_file($cover['tmp_name'], $dest);
    $res['uploaded']['cover'] = 'uploads/covers/' . $fn;
  } else $res['error_cover'] = 'Invalid image';
}

if(isset($res['uploaded']['song'])) {
  $title = $_POST['title'] ?? pathinfo($res['uploaded']['song'], PATHINFO_FILENAME);
  $artist_id = null;
  $album_id = null;
  $stmt = $pdo->prepare('INSERT INTO songs(title,artist_id,album_id,file_path,cover_path) VALUES(?,?,?,?,?)');
  $stmt->execute([$title,$artist_id,$album_id,$res['uploaded']['song'],$res['uploaded']['cover'] ?? null]);
}

header('Content-Type: application/json');
echo json_encode($res);
