<?php
require __DIR__ . '/common.php';
$id = intval($_GET['id'] ?? 0);
if($id <= 0) { http_response_code(400); exit; }
$stmt = $pdo->prepare('SELECT file_path FROM songs WHERE id = ?');
$stmt->execute([$id]);
$row = $stmt->fetch();
if(!$row) { http_response_code(404); exit; }
$path = __DIR__ . '/../' . $row['file_path'];
if(!file_exists($path)) { http_response_code(404); exit; }

$size = filesize($path);
$fm = fopen($path, 'rb');
$begin = 0;
$end = $size - 1;

if (isset($_SERVER['HTTP_RANGE'])) {
    $range = $_SERVER['HTTP_RANGE'];
    list(, $range) = explode('=', $range, 2);
    if (strpos($range, ',') !== false) { header('HTTP/1.1 416 Requested Range Not Satisfiable'); exit; }
    if ($range[0] == '-') {
        $begin = $size - intval(substr($range, 1));
    } else {
        $range = explode('-', $range);
        $begin = intval($range[0]);
        if (isset($range[1]) && is_numeric($range[1])) $end = intval($range[1]);
    }
    if ($begin > $end || $begin > $size - 1 || $end >= $size) { header('HTTP/1.1 416 Requested Range Not Satisfiable'); exit; }
    fseek($fm, $begin);
    header('HTTP/1.1 206 Partial Content');
} else {
    header('HTTP/1.1 200 OK');
}
$ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
$mime = 'audio/mpeg'; if($ext === 'ogg') $mime = 'audio/ogg'; if($ext === 'wav') $mime = 'audio/wav';
header("Content-Type: $mime");
header("Accept-Ranges: bytes");
header("Content-Length: " . ($end - $begin + 1));
header("Content-Range: bytes $begin-$end/$size");

$buffer = 1024 * 8;
while(!feof($fm) && ($p = ftell($fm)) <= $end) {
    if ($p + $buffer > $end) $buffer = $end - $p + 1;
    echo fread($fm, $buffer);
    flush();
}
fclose($fm);
exit;
