<?php
require __DIR__ . '/common.php';
if($_SERVER['REQUEST_METHOD'] !== 'POST') { header('Location: /frontend/register.html'); exit; }
$email = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
$password = $_POST['password'] ?? '';
$display = trim($_POST['display_name'] ?? '');

if(!$email || strlen($password) < 6) {
  header('Location: /frontend/register.html?error=1'); exit;
}

$hash = password_hash($password, PASSWORD_DEFAULT);
try {
  $stmt = $pdo->prepare('INSERT INTO users (email,password_hash,display_name) VALUES (?,?,?)');
  $stmt->execute([$email,$hash,$display]);
  $id = $pdo->lastInsertId();
  $_SESSION['user_id'] = $id;
  $_SESSION['email'] = $email;
  $_SESSION['display'] = $display;
  $_SESSION['is_admin'] = 0;
  header('Location: /frontend/home.html');
  exit;
} catch (PDOException $e) {
  header('Location: /frontend/register.html?error=exists');
  exit;
}
