<?php
require __DIR__ . '/common.php';
if($_SERVER['REQUEST_METHOD'] !== 'POST') { header('Location: /frontend/login.html'); exit; }
$email = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
$password = $_POST['password'] ?? '';
$stmt = $pdo->prepare('SELECT id,password_hash,is_admin,display_name FROM users WHERE email = ?');
$stmt->execute([$email]);
$user = $stmt->fetch();
if(!$user || !password_verify($password, $user['password_hash'])) {
  header('Location: /frontend/login.html?error=1'); exit;
}
session_regenerate_id(true);
$_SESSION['user_id'] = $user['id'];
$_SESSION['email'] = $email;
$_SESSION['display'] = $user['display_name'];
$_SESSION['is_admin'] = (int)$user['is_admin'];
header('Location: /frontend/home.html');
exit;
