<?php
// common.php - include in scripts
if(session_status() === PHP_SESSION_NONE) session_start();
$config = require __DIR__ . '/config.php';
try {
  $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
  $pdo = new PDO($dsn, $config['db_user'], $config['db_pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
  ]);
} catch (PDOException $e) {
  http_response_code(500);
  error_log('DB connect error: ' . $e->getMessage());
  echo 'DB connection error';
  exit;
}

function is_logged_in() {
  return !empty($_SESSION['user_id']);
}
function is_admin() {
  return !empty($_SESSION['is_admin']);
}
