<?php
require __DIR__ . '/../common.php';
header('Content-Type: application/json');
if(!is_logged_in()){ http_response_code(401); echo json_encode(['error'=>'auth']); exit; }
$method = $_SERVER['REQUEST_METHOD'];
if($method === 'GET'){
  $stmt = $pdo->prepare('SELECT * FROM playlists WHERE user_id = ? ORDER BY created_at DESC');
  $stmt->execute([$_SESSION['user_id']]);
  echo json_encode($stmt->fetchAll());
} elseif($method === 'POST'){
  $title = trim($_POST['title'] ?? 'Yeni Liste');
  $stmt = $pdo->prepare('INSERT INTO playlists (user_id,title) VALUES (?,?)');
  $stmt->execute([$_SESSION['user_id'],$title]);
  echo json_encode(['ok'=>true,'id'=>$pdo->lastInsertId()]);
} elseif($method === 'DELETE'){
  parse_str(file_get_contents('php://input'), $input);
  $id = (int)$input['id'];
  $pdo->prepare('DELETE FROM playlists WHERE id=? AND user_id=?')->execute([$id,$_SESSION['user_id']]);
  echo json_encode(['ok'=>true]);
}
